openUBMC 综合事件严重等级LED点灯功能详细设计说明书

<table>
    <tr>
        <td>所属SIG组:</td>
        <td>hardware</td>
    </tr>
    <tr>
        <td>落入版本:</td>
        <td>25.09</td>
    </tr>
    <tr>
        <td>设计人员:</td>
        <td>mao_0v0</td>
    </tr>
    <tr>
        <td>日期:</td>
        <td>2025-8-5</td>
    </tr>
</table>

**Copyright © 2025 openUBMC Community**

您对"本文档"的复制，使用，修改及分发受木兰宽松许可证, 第2版协议(以下简称"MulanPSL2")的约束。
为了方便用户理解，您可以通过访问<https://license.coscl.org.cn/MulanPSL2>了解MulanPSL2的概要 (但不是替代)。
MulanPSL2的完整协议内容您可以访问如下网址获取：<https://license.coscl.org.cn/MulanPSL2>。

**改版记录**

<table>
    <tr>
        <th>日期</th>
        <th>修订版本</th>
        <th>修订描述</th>
        <th>作者</th>
        <th>审核</th>
    </tr>
    <tr>
        <td>2025-8-5</td>
        <td>V1.0</td>
        <td>初版，支持综合事件严重等级LED点灯功能</td>
        <td>mao_0v0</td>
        <td></td>
    </tr>
</table>

**List of abbreviations**  **缩略语清单** ：

<table>
    <tr>
        <th>Abbreviations 缩略语</th>
        <th>Full spelling 英文全名</th>
        <th>Chinese explanation 中文解释</th>
    </tr>
    <tr>
        <td>BMC</td>
        <td>Baseboard Management Controller</td>
        <td>基板管理控制器</td>
    </tr>
    <tr>
        <td>LED</td>
        <td>Light Emitting Diode</td>
        <td>发光二极管</td>
    </tr>
    <tr>
        <td>SEL</td>
        <td>System Event Log</td>
        <td>系统事件日志</td>
    </tr>
</table>

[TOC]

## 1.功能分析

### 1.1 功能背景
<!-- 描述该需求的来源或背景，比如：支撑XXX功能、XXX优化等；以及该需求对用户（含组件）带来什么具体价值，如果没有该需求，对用户（含组件）带来什么损失； -->
需支持综合传感器事件和精细化事件的严重等级进行LED点灯功能，通过综合两种事件的严重等级，取最严重的等级用于健康灯的点灯策略。该功能能够帮助运维人员快速识别系统健康状态，提高故障诊断效率。

### 1.2 功能描述
<!-- 描述该需求交付的整体功能，主要实现XXX功能，解决XXX问题，明确方案如何实现 -->
实现综合传感器事件和精细化事件的严重等级进行LED点灯功能，主要实现：
1. 获取传感器事件严重等级
2. 获取精细化事件的严重等级  
3. 综合以上两种事件的严重等级，取两者最严重的等级用于健康灯的点灯策略
4. 根据综合严重等级控制LED健康灯的显示状态（常亮、闪烁、熄灭等）

### 1.3 功能场景
<!-- 描述该需求的业务使用场景，内容包括：
1) 场景出发条件及对象：什么角色/工具/接口等在什么具体情况下使用该特性，使用对象技能如何？
2) 使用时间及频度
3) 描述该特性主要有哪些场景、子场景及关键任务操作 -->
- **场景触发条件**：BMC运行正常，系统启动后自动启动
- **使用对象**：开发人员、运维人员、测试人员
- **使用时间及频度**：系统运行期间持续运行，实时响应状态变化

### 1.4 功能列表
<!-- 描述该需求交付的功能列表，内容包括：列出功能详细描述，标题、描述。 -->
| 功能编号 | 功能标题 | 功能描述 |
| ------- | ------- | -------- |
| 1 | 传感器事件严重等级获取 | 获取传感器事件的严重等级信息 |
| 2 | 精细化事件严重等级获取 | 获取精细化事件的严重等级信息 |
| 3 | 综合严重等级计算 | 综合两种事件严重等级，取最严重等级 |
| 4 | LED点灯策略执行 | 根据综合严重等级控制LED健康灯显示 |

## 2.功能设计

### 2.1 总体方案分析
<!-- 描述该方案的总体设计（注：相关输出方案可同步刷新到各组件仓） -->

#### 2.1.1 方案详细设计
<!-- 描述该方案的整体实现，内容包括：涉及的关键点，实现策略等 -->

**方案概述**：
- **传感器事件监控**：监听传感器事件，获取其严重等级
- **精细化事件监控**：监听精细化事件，获取其严重等级
- **严重等级综合**：比较两种事件的严重等级，取最严重的等级
- **LED点灯控制**：根据综合严重等级控制LED健康灯显示

**开发视图**：
<!-- 开发视图面向系统开发及软件管理，描述系统代码结构，构建结构的视图，主要解决系统技术实现和开发的问题，它依托逻辑视图，描述代码、构建结构 -->
```
-- 核心函数：led_health_task()
-- 功能：启动综合事件监听和LED点灯策略
-- 参数：无
-- 返回值：无

-- 综合严重等级计算函数
-- 功能：综合传感器事件和精细化事件的严重等级
-- 返回值：综合后的严重等级
```

**运行视图**：
<!-- 运行视图面向系统运行，描述系统启动过程、运行期交互的视图，主要解决系统运行期交互，描述各可执行交付件在运行期的交互关系 -->

```mermaid
flowchart TD
    A[系统启动] --> B[BMC运行正常]
    B --> C[初始化]
    C --> D[等待健康灯对象就绪]
    D --> E[启动综合事件监听]
    E --> F[注册传感器事件监听]
    E --> G[注册精细化事件监听]
    F --> H[事件变化触发]
    G --> H
    H --> I[获取传感器事件严重等级]
    H --> J[获取精细化事件严重等级]
    I --> K[综合严重等级计算]
    J --> K
    K --> L[取最严重等级]
    L --> M[LED点灯策略执行]
    M --> N[更新LED健康灯状态]
    N --> O[记录日志]
    O --> P[等待下次事件变化]
    P --> H
```

#### 2.1.2 内部依赖分析
<!-- 是否涉及与其他组件接口依赖，如果涉及需要确认当前是否已完成，是否匹配当前需求开发诉求 -->
**内部依赖**：
不涉及

#### 2.1.3 外部依赖分析
<!-- 是否涉及与平台SDK的依赖关系 -->
**外部依赖**：
- 传感器事件数据源
- 精细化事件数据源

#### 2.1.4 北向接口分析
<!-- 需要分析当前功能是否有以下接口影响，如果有影响，则需要具体的补充影响点。其中注意点如下：
（1）如果有新增IPMI接口，请排查代码中IPMI命令注册的过滤字段，是否完全和IPMI命令的定义一致？
（2）新增一个接口时，需要咨询SIG组是否还有其他的接口受影响 -->
| 特性 | SNMP | CLI | WEB | KVM_VMM | IPMI(RMCP/RMCP+) | HMM | Redfish |
| ---- | ---- | --- | --- | ------ | ---------------- | --- | ------- |

不涉及

#### 2.1.5 兼容性分析
<!-- 当前的功能对现有在网的功能是否有影响，具体的影响点进行分析之后输出影响分析表格 -->
- 该功能为新增功能，不影响现有LED控制功能
- 根据策略闪灯

#### 2.1.6 定制化接口分析
<!-- 如果支持定制化设置，则需要给出定制化时的默认值（空定制化项条件下的设置值），如果涉及到定制化接口变更或新增，注意定制化接口文档需配套修改。注意定制化默认值变更对白牌包的影响 -->
不涉及

#### 2.1.7 导入导出分析
<!-- 如果支持导入导出的配置，则需要分析导入导出的schema。 -->
不涉及

#### 2.1.8 传感器分析
<!-- 如果需要新增传感器，则需要提前登记和评审新增的传感器要素。新增传感器评审需要上SIG-Interface进行评审 -->
不涉及

#### 2.1.9 精准告警事件分析
<!-- 如果需要新增事件，则需要提前登记和评审新增的时间要素 -->
不涉及

#### 2.1.10 系统锁定分析
<!-- 对外的接口或者命令是否支持系统锁定 -->
不涉及

#### 2.1.11 用例场景分析
<!-- 以表格的形式输出该需求涉及的用例场景 -->
| 用例编号 | 场景描述 | 预期结果 |
| ------- | ------- | ------- |
| 1 | 传感器事件Normal，精细化事件Critical | LED显示Critical状态闪灯 |
| 2 | 传感器事件Major，精细化事件Minor | LED显示Major状态 |
| 3 | 传感器事件Critical，精细化事件Critical | LED显示Critical状态 |
| 4 | 只有某一个产生事件 | LED根据策略显示状态 |
| 5 | 只有某一个产生事件，但是获取失败 | 此次保持和上次一样，不做变更 |
| 6 | bmc启动时初始化 | LED根据当前事件状态正确显示 |

### 2.2 非功能质量属性设计

#### 2.2.1 扩展性分析
<!-- 考虑后续新增类似功能可以很好地扩展 -->
- 支持新增事件类型和严重等级
- 支持自定义LED点灯策略

#### 2.2.2 重用性分析
<!-- 是否为通用处理方式、接口，如果是得考虑重用性 -->
- LED控制接口可被其他功能模块重用
- 事件监听机制可被其他监控功能重用
- 严重等级计算逻辑可被其他健康检查功能重用

#### 2.2.3 可测试性分析
<!-- 此需求如何验证，是否可直接验证，or通过XXX功能覆盖验证，or需要单独怎加测试接口验证 -->
- 可直接验证

#### 2.2.4 资料分析
<!-- 是否涉及资料修改 -->
不涉及

#### 2.2.5 资源使用分析
<!-- 新增线程、内存分配、模型属性名长度是否合理，CPU占用率是否会激增，Flash中新增文件是否合理（频繁读写Flash会大幅缩短emmc寿命）；是否涉及消息队列，如果涉及请检查是否存在某些场景下消息队列会满导致消息丢失，例如大量消息发送到队列且处理消息需要耗费较长时间的场景。 -->
不涉及

#### 2.2.6 可靠性分析
| 编号 | 场景 | 问题描述 | 可靠性影响 | 问题级别 | 建议解决方案/需求 | 讨论结果 | 跟踪人 | 备注 |
| --- | --- | --- | --- | --- | --- | --- | --- | --- |
| 1 | 系统健康状态获取失败 | LED状态无法更新 | 中等 | 中 | 添加异常处理和重试机制 | 已确认 | - | 需要实现 |

#### 2.2.7 安全性分析
| 安全合规项 | 是否涉及 | 现有的防护措施 |
| --- | --- | --- |
| 访问控制 | 是 | - |
| 敏感数据 | 否 | - |
| 日志 | 是 | 记录LED状态变化和事件处理日志 |
| 文档 | 否 | - |
| 加密及算法 | 否 | - |
| 新增关键资源备份、恢复 | 是 | - |
| 新增对外接口入参校验 | 是 | 事件数据格式和范围校验 |
| 新增开源及三方软件引入 | 否 | - |

## 3.功能实现

### 3.1【功能编号】综合事件严重等级LED点灯功能实现
<!-- 通过表格、流程图、简明文字描述提供，力求容易看懂、容易实现，详细描述细节。 -->

#### 3.1.1 功能实现设计

**核心流程**：

```mermaid
flowchart TD
    A[开始] --> B[等待系统就绪]
    B --> C{健康灯对象是否就绪}
    C -->|否| B
    C -->|是| D[启动综合监听]
    D --> E[注册传感器事件监听]
    D --> F[注册精细化事件监听]
    D --> G[注册策略配置监听器]
    E --> H[执行初始LED策略]
    F --> H
    G --> H
    H --> I[等待事件变化]
    I --> J{事件变化?}
    J -->|否| I
    J -->|是| K[获取传感器事件严重等级]
    J --> L[获取精细化事件严重等级]
    K --> M[综合严重等级计算]
    L --> M
    M --> N{有配置特定参考源?}
    N -->|是| O[使用指定参考源]
    N -->|否| P[取最严重等级]
    O --> Q[执行LED点灯策略]
    P --> Q
    Q --> R[更新LED状态]
    R --> S[记录日志]
    S --> I
```

#### 3.1.2 功能详细设计

**严重等级计算逻辑**：

```mermaid
flowchart TD
    A[开始计算] --> B[获取传感器事件严重等级]
    A --> C[获取精细化事件严重等级]
    B --> D{传感器事件可用?}
    C --> E{精细化事件可用?}
    D -->|否| F[只使用精细化事件]
    D -->|是| G[检查配置参考源]
    E -->|否| H[只使用传感器事件]
    E -->|是| G
    G --> I{配置了特定参考源?}
    I -->|是| J[使用指定参考源]
    I -->|否| K[比较两个严重等级]
    K --> L[取数值较大的严重等级]
    L --> M[转换为状态字符串]
    J --> N[返回结果]
    F --> N
    H --> N
    M --> N
    N --> O[结束]
```

#### 3.1.3 开发者测试

##### 3.1.3.1 单元测试
<!-- UT，主要是功能单元测试，测试对象是功能单元接口。UT测试设计要从黑盒（功能）角度设计，从输入(I)、处理（B）、预期输出（O）的角度进行用例分析设计，测试覆盖率仅作为反馈，用于分析哪些功能场景没有覆盖到，从而指导测试设计优化并补充测试用例 -->
- **测试用例1**：传感器事件Normal，精细化事件Critical时的综合计算
- **测试用例2**：根据策略，led灯是否根据健康状态设置

##### 3.1.3.2 集成测试
<!-- IT，主要是组件/模块内的集成测试，测试对象是模块/组件接口。IT测试设计将模块/组件当作黑盒测试，IT测试用例中禁止对组件/模块内部代码打桩，如果确实有少量场景难以构造，可以考虑在测试框架中统一打桩并提供接口供测试用例调用构造场景。
说明：API测试属于IT，其测试对象是微服务接口。
PCST，是指PC上的服务集成测试，测试对象是功能需求。PCST测试设计，要覆盖正常功能、异常功能和交叉功能，采用灰盒 -->